/*
 * Demo ET-ESP32-RS485 Hardware Board
 * MCU      : ESP32-WROVER
 *          : Arduino Tools Board : ESP32 Wrover Module
 * Software : https://dl.espressif.com/dl/package_esp32_index.json        
 * Reserve  : Boot Config       
 *          : -> IO0(BOOT)
 *          : -> IO2(Don't Card on 3V3V Version)
 *          : -> IO5
 *          : -> IO12(MTDI)
 *          : -> IO15(MTDO)
 * Reserve  : SFLASH        
 *          : -> CMD
 *          : -> CLK
 *          : -> SD0
 *          : -> SD1
 *          : -> SD2
 *          : -> SD3
 * Debug    : Serial0 : USART0(USB)        
 *          : -> RX0(Debug & Download:IO3)
 *          : -> TX0(Debug & Download:IO1)
 * NB-IoT   : Serial1 : SIM7020E(BK-7020 V2)       
 *          : -> RX1(T:IO14)
 *          : -> TX1(R:IO13)
 *          : -> PWRKEY(K:IO33)
 *          : -> SLEEP(S:IO32)
 * RS485    : Serial1 : RS485  
 *          : -> RX2(IO26)
 *          : -> TX2(IO27)
 *          : -> DIR(Direction : IO25 : LOW = Receive, HIGH = Send)
 * I2C#1    : I2C BUS
 *          : -> SCL1(IO22)
 *          : -> SDA1(IO21)
 * RTC      : -> RTC:DS3231/DS3232
 *          : -> PCF8574/A(Relay8)
 *          : -> PCF8574/A(DC-IN8)
 * LED      : LED Status(Active High)
 *          : -> LED0(IO2)
 * Demo     : Test Internal RELAY8,Internal OPTO-INPUT8              
 *          : External RELAY8,External OPTO-INPUT8    
 *          : Master = ET-ESP32 RS485 
 *          :          Relay PCF8574 = ID0
 *          :          OPTO Input PCF8574A = ID0
 *          : Slave =  ET-I2C IN8/OUT8
 *          :          Relay PCF8574 = ID1
 *          :          OPTO Input PCF8574A = ID1
 */
 
//=================================================================================================
#include <Wire.h> 
#include "ETT_PCF8574.h"
//=================================================================================================

//=================================================================================================
// Start of Default Hardware : ET-ESP32-RS485
//=================================================================================================
// Remap Pin USART -> C:\Users\Admin\Documents\Arduino\hardware\espressif\esp32\cores\esp32\HardwareSerial.cpp
//                    C:\Users\Admin\AppData\Local\Arduino15\packages\esp32\hardware\esp32\1.0.0\cores\esp32\HardwareSerial.cpp
//=================================================================================================
#include <HardwareSerial.h>
//=================================================================================================
#define SerialDebug  Serial                                                                       // USB Serial(Serial0)
//=================================================================================================
#define SerialNBIOT_RX_PIN    14
#define SerialNBIOT_TX_PIN    13
#define SerialNBIOT  Serial1                                                                      // Serial1(IO13=TXD,IO14=RXD)
//=================================================================================================
#define SerialRS485_RX_PIN    26
#define SerialRS485_TX_PIN    27
#define SerialRS485  Serial2                                                                      // Serial2(IO27=TXD,IO26=RXD)
//=================================================================================================
#define RS485_DIRECTION_PIN   25                                                                  // ESP32-WROVER :IO25
#define RS485_RXD_SELECT      LOW
#define RS485_TXD_SELECT      HIGH
//=================================================================================================
#define SIM7020E_PWRKEY_PIN   33                                                                  // ESP32-WROVER :IO33
#define SIM7020E_SLEEP_PIN    32                                                                  // ESP32-WROVER :IO32
#define SIM7020E_PWRKEY_LOW   LOW                                                                 // Start Power-ON
#define SIM7020E_PWRKEY_HIGH  HIGH                                                                // Release Signal
#define SIM7020E_SLEEP_LOW    LOW                                                                 // Pull-Up DTR to Enable Sleep
#define SIM7020E_SLEEP_HIGH   HIGH                                                                // DTR=Low(Wakeup From Sleep)
//=================================================================================================
#define I2C_SCL1_PIN          22                                                                  // ESP32-WROVER : IO22(SCL1)
#define I2C_SDA1_PIN          21                                                                  // ESP32-WROVER : IO21(SDA1)
//=================================================================================================

//=================================================================================================
#define LED_PIN               2                                                                   // ESP-WROVER  : IO2
#define LedON                 1
#define LedOFF                0
//=================================================================================================
#define CS_SD_CARD_PIN        4                                                                   // ESP-WROVER  : IO4
#define SD_CARD_DISABLE       1
#define SD_CARD_ENABLE        0
//=================================================================================================
// End of Default Hardware : ET-ESP32-RS485
//=================================================================================================

//=================================================================================================
ETT_PCF8574 master_relay(PCF8574_ID_DEV0);                                                        // ET-ESP32-RS485  : Output Relay(PCF8574:ID0)
ETT_PCF8574 master_input(PCF8574A_ID_DEV0);                                                       // ET-ESP32-RS485  : Input OPTO(PCF8574A:ID0) 
//=================================================================================================
ETT_PCF8574 slave_relay1(PCF8574_ID_DEV1);                                                        // ET-I2C IN8/OUT8 : Output Relay(PCF8574:ID1)
ETT_PCF8574 slave_input1(PCF8574A_ID_DEV1);                                                       // ET-I2C IN8/OUT8 : Input OPTO(PCF8574A:ID1) 
//=================================================================================================
uint8_t state;
unsigned long lastGetDelayTime = 0;
//=================================================================================================
  
void setup() 
{
  //===============================================================================================
  // Start of Initial Default Hardware : ET-ESP32-RS485
  //===============================================================================================
  pinMode(LED_PIN, OUTPUT);
  digitalWrite(LED_PIN, LedOFF);
  //===============================================================================================
  pinMode(CS_SD_CARD_PIN, OUTPUT);
  digitalWrite(CS_SD_CARD_PIN, SD_CARD_DISABLE);
  //===============================================================================================
  Wire.begin(I2C_SDA1_PIN,I2C_SCL1_PIN);                                                      
  //===============================================================================================
  pinMode(RS485_DIRECTION_PIN, OUTPUT);                                                          // RS485 Direction
  digitalWrite(RS485_DIRECTION_PIN, RS485_RXD_SELECT);
  //===============================================================================================
  SerialDebug.begin(115200);
  while(!SerialDebug);
  //===============================================================================================
  SerialNBIOT.begin(115200, SERIAL_8N1, SerialNBIOT_RX_PIN, SerialNBIOT_TX_PIN);
  while(!SerialNBIOT);
  //===============================================================================================
  SerialRS485.begin(9600, SERIAL_8N1, SerialRS485_RX_PIN, SerialRS485_TX_PIN);
  while(!SerialRS485);
  //===============================================================================================
  // End of Initial Default Hardware : ESP32
  //===============================================================================================

  //===============================================================================================
  SerialDebug.println();
  SerialDebug.println("ET-ESP32-RS485....Demo Master Relay & OPTO Input");
  SerialDebug.println("ET-I2C IN8/OUT8...Demo Slave1 Relay & OPTO Input");
  SerialDebug.println();
  //===============================================================================================
  
  //===============================================================================================
  master_relay.begin(0xFF);
  slave_relay1.begin(0xFF);
  //===============================================================================================
  master_input.begin(0xFF);
  slave_input1.begin(0xFF);
  //===============================================================================================
  master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
  master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
  //
  slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
  slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
  //===============================================================================================
  state = 8;
  //=============================================================================================== 
}

void loop() 
{
  //===============================================================================================
  // Start of Read & Write I2C In/Out PCF8574
  //===============================================================================================
  if(millis() - lastGetDelayTime > 500ul)                                                       // 0.5-Second
  {
    //=============================================================================================
    state++;
    if(state > 7) 
    {
      state = 0;                                                                                  // 0,1,...,7
      delay(2000);
      SerialDebug.println();
    }
    //=============================================================================================
    switch(state) 
    {
      case 0: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 1: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 2: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 3: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 4: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 5: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 6: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_ON);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_ON);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_OFF);
        //=========================================================================================
      break;
      
      case 7: 
        //=========================================================================================
        master_relay.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        master_relay.writePin(RELAY_OUT0_PIN, RELAY_ON);
        //
        slave_relay1.writePin(RELAY_OUT7_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT6_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT5_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT4_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT3_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT2_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT1_PIN, RELAY_OFF);
        slave_relay1.writePin(RELAY_OUT0_PIN, RELAY_ON);
        //=========================================================================================
      break;
    }
    
    //=============================================================================================
    delay(10);                                                                                   //Wait Output Relay On Input Opto Complete
    //=============================================================================================
    Serial.print("Master IN = ");
    //=============================================================================================
    Serial.print(master_input.readPin(OPTO_IN7_PIN));
    Serial.print(master_input.readPin(OPTO_IN6_PIN));
    Serial.print(master_input.readPin(OPTO_IN5_PIN));
    Serial.print(master_input.readPin(OPTO_IN4_PIN));
    Serial.print(master_input.readPin(OPTO_IN3_PIN));
    Serial.print(master_input.readPin(OPTO_IN2_PIN));
    Serial.print(master_input.readPin(OPTO_IN1_PIN));
    Serial.print(master_input.readPin(OPTO_IN0_PIN));
    //=============================================================================================
    Serial.print(" -> Slave IN = ");
    //=============================================================================================
    Serial.print(slave_input1.readPin(OPTO_IN7_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN6_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN5_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN4_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN3_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN2_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN1_PIN));
    Serial.print(slave_input1.readPin(OPTO_IN0_PIN));
    //=============================================================================================
    Serial.println();
    //=============================================================================================
    lastGetDelayTime = millis();
    //=============================================================================================  
  }
  //===============================================================================================
  // End of Read & Write I2C In/Out PCF8574
  //===============================================================================================
  
}

